/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.wishingforsunshine.blocks;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.libs.repack_wishingforsunshine.noobutil.util.VoxelUtil;
import noobanidus.mods.wishingforsunshine.config.ItemType;
import noobanidus.mods.wishingforsunshine.init.ModTiles;
import noobanidus.mods.wishingforsunshine.tiles.WishingWellTile;

public class WellBlock
extends Block {
    private static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE_NORTH = VoxelUtil.multiOr(Block.func_208617_a((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)6.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)3.0), Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)6.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.func_208617_a((double)1.0, (double)18.6, (double)6.5, (double)15.0, (double)19.6, (double)9.5), Block.func_208617_a((double)1.0, (double)17.6, (double)5.5, (double)15.0, (double)18.6, (double)7.5), Block.func_208617_a((double)1.0, (double)17.6, (double)8.5, (double)15.0, (double)18.6, (double)10.5), Block.func_208617_a((double)1.0, (double)16.6, (double)4.5, (double)15.0, (double)17.6, (double)6.5), Block.func_208617_a((double)1.0, (double)16.6, (double)9.5, (double)15.0, (double)17.6, (double)11.5), Block.func_208617_a((double)1.0, (double)15.6, (double)3.5, (double)15.0, (double)16.6, (double)5.5), Block.func_208617_a((double)1.0, (double)15.6, (double)10.5, (double)15.0, (double)16.6, (double)12.5), Block.func_208617_a((double)1.0, (double)14.6, (double)2.5, (double)15.0, (double)15.6, (double)4.5), Block.func_208617_a((double)1.0, (double)14.6, (double)11.5, (double)15.0, (double)15.6, (double)13.5), Block.func_208617_a((double)1.0, (double)13.6, (double)1.5, (double)15.0, (double)14.6, (double)3.5), Block.func_208617_a((double)1.0, (double)13.6, (double)12.5, (double)15.0, (double)14.6, (double)14.5), Block.func_208617_a((double)13.0, (double)6.0, (double)6.5, (double)14.0, (double)17.0, (double)9.5), Block.func_208617_a((double)2.0, (double)6.0, (double)6.5, (double)3.0, (double)17.0, (double)9.5), Block.func_208617_a((double)3.0, (double)11.0, (double)7.5, (double)13.0, (double)12.0, (double)8.5), Block.func_208617_a((double)3.0, (double)16.0, (double)6.5, (double)13.0, (double)17.0, (double)9.5));
    private static final VoxelShape SHAPE_WEST = VoxelUtil.multiOr(Block.func_208617_a((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)6.0, (double)16.0), Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)6.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)3.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.func_208617_a((double)6.5, (double)18.6, (double)1.0, (double)9.5, (double)19.6, (double)15.0), Block.func_208617_a((double)8.5, (double)17.6, (double)1.0, (double)10.5, (double)18.6, (double)15.0), Block.func_208617_a((double)5.5, (double)17.6, (double)1.0, (double)7.5, (double)18.6, (double)15.0), Block.func_208617_a((double)9.5, (double)16.6, (double)1.0, (double)11.5, (double)17.6, (double)15.0), Block.func_208617_a((double)4.5, (double)16.6, (double)1.0, (double)6.5, (double)17.6, (double)15.0), Block.func_208617_a((double)10.5, (double)15.6, (double)1.0, (double)12.5, (double)16.6, (double)15.0), Block.func_208617_a((double)3.5, (double)15.6, (double)1.0, (double)5.5, (double)16.6, (double)15.0), Block.func_208617_a((double)11.5, (double)14.6, (double)1.0, (double)13.5, (double)15.6, (double)15.0), Block.func_208617_a((double)2.5, (double)14.6, (double)1.0, (double)4.5, (double)15.6, (double)15.0), Block.func_208617_a((double)12.5, (double)13.6, (double)1.0, (double)14.5, (double)14.6, (double)15.0), Block.func_208617_a((double)1.5, (double)13.6, (double)1.0, (double)3.5, (double)14.6, (double)15.0), Block.func_208617_a((double)6.5, (double)6.0, (double)13.0, (double)9.5, (double)17.0, (double)14.0), Block.func_208617_a((double)6.5, (double)6.0, (double)2.0, (double)9.5, (double)17.0, (double)3.0), Block.func_208617_a((double)7.5, (double)11.0, (double)3.0, (double)8.5, (double)12.0, (double)13.0), Block.func_208617_a((double)6.5, (double)16.0, (double)3.0, (double)9.5, (double)17.0, (double)13.0));
    private static final VoxelShape SHAPE_COLLIDE = VoxelUtil.multiOr(Block.func_208617_a((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)6.0, (double)16.0), Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)6.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)3.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));

    public WellBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    private void alertServer(UUID source, ItemType result) {
        MinecraftServer server;
        ServerPlayerEntity player;
        if (result != null && (player = (server = ServerLifecycleHooks.getCurrentServer()).func_184103_al().func_177451_a(source)) != null) {
            for (ServerPlayerEntity o : server.func_184103_al().func_181057_v()) {
                o.func_145747_a((ITextComponent)new TranslationTextComponent("wishingforsunshine.message." + result.toString().toLowerCase(), new Object[]{player.func_145748_c_()}).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA))), Util.field_240973_b_);
            }
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof WishingWellTile && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            UUID playerID = item.func_200214_m();
            ItemType result = ((WishingWellTile)te).itemCollide(item);
            if (playerID != null) {
                this.alertServer(playerID, result);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemType result;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WishingWellTile && (result = ((WishingWellTile)te).itemActivated(player, hand, player.func_184586_b(hand))) != null) {
            if (!world.func_201670_d()) {
                this.alertServer(player.func_110124_au(), result);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, trace);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WishingWellTile((TileEntityType<? extends WishingWellTile>)((TileEntityType)ModTiles.WISHING_WELL.get()));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NORTH;
        }
        return SHAPE_WEST;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return SHAPE_COLLIDE;
    }
}

